require 'sketchup'
require 'extensions'
require 'json'

# This is the SketchUp entry point for the Rayscaper extension.
module Rayscaper
  dir = __dir__.dup
  dir.force_encoding('UTF-8') if dir.respond_to?(:force_encoding)
  EXTENSION_INFO = ::JSON.parse(File.read(File.join(dir, 'rayscaper/extension_info.json')),
                                symbolize_names: true).freeze

  unless file_loaded?(__FILE__)
    extension = SketchupExtension.new(EXTENSION_INFO[:name], 'rayscaper/main')
    extension.description = EXTENSION_INFO[:description]
    extension.version = EXTENSION_INFO[:version]
    extension.copyright = EXTENSION_INFO[:copyright]
    extension.creator = EXTENSION_INFO[:creator]
    Sketchup.register_extension(extension, true)
    file_loaded(__FILE__)
  end
end
